export const aggregateMetrics = (fileMetrics, processedFiles, output, tokenCounter) => {
    const totalFiles = processedFiles.length;
    const totalCharacters = output.length;
    const totalTokens = tokenCounter.countTokens(output);
    const fileCharCounts = {};
    const fileTokenCounts = {};
    for (const file of fileMetrics) {
        fileCharCounts[file.path] = file.charCount;
        fileTokenCounts[file.path] = file.tokenCount;
    }
    return {
        totalFiles,
        totalCharacters,
        totalTokens,
        fileCharCounts,
        fileTokenCounts,
    };
};
//# sourceMappingURL=aggregateMetrics.js.map